/**
  Copyright (c) 2008 Freescale Semiconductor
  
  \file       *.c
  \brief      This file contains the animations
  \author     Freescale Semiconductor
  \author     Automotive Systems Solutions Engineering
  \author     DB, r54930
  \version    1.0
  \date       03/Nov/2011
  
  * History:  03/Nov/2011- Initial Version

* Copyright (c) 2008, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
   
*/

#include "common.h"
//#include "Graphics.h"
#include "Display.h"
#include "Flib.h"
#include "..\HAL\GALLO.h"
#include "..\SERVICES\DMAHandler.h"
#include "FontLibrary.h"
#include "..\MovieClips\mc_parameters.h"
#include "VarAnimator.h"

/* typesfdefs */

typedef struct 
{
	void 		*target;
	uint32_t	from;
	uint32_t	to;
	int16_t		inc;
	uint8_t		speed;
	uint8_t		method;
}AnimationsI_t;

typedef struct 
{
	float  	    *target;
	float		from;
	float		to;
	float		inc;
	uint8_t		speed;
	uint8_t		method;
	uint8_t		speedL;
	Graphics_CallbackType callback;	
}AnimationsF_t;


/* global variables */
uint8_t AnimationIState[16];
uint8_t AnimationFState[16];

AnimationsI_t Animation_aI[16];
AnimationsF_t Animation_aF[16];

/*  prototypes   */
void AnimatorF();
uint8_t GetNextFreeSlotF();
void AnimateF(uint8_t index);


/* code */

uint8_t SetupAniF(	float *target,
	float		from,
	float		to,
	float		inc,
	uint8_t		speed,
	uint8_t		method,
	Graphics_CallbackType callback	
)
{
	uint8_t i;
	i = GetNextFreeSlotF();
	if (i < 16)
	{
		Animation_aF[i].target = target;
		Animation_aF[i].from = from;
		Animation_aF[i].to = to;
		Animation_aF[i].inc = inc;
		Animation_aF[i].speedL = Animation_aF[i].speed = speed;
		Animation_aF[i].method = method;
		Animation_aF[i].callback = callback;
		AnimationFState[i] = 1;
	}
	else return 0xFF;
}

uint8_t GetNextFreeSlotF()
{
uint8_t i;

	for(i=0;i<=16;i++) if(AnimationFState[i] == 0) return i;
	return 16;
}

void AnimatorF()
{
uint8_t i;
	for(i=0;i<=16;i++)
	{
		if (AnimationFState[i] != 0) 
		{
			if (--Animation_aF[i].speed == 0) AnimateF(i); 
		}
	}
}

void AnimateF(uint8_t i)
{

uint8_t a;
	
	Animation_aF[i].speed = Animation_aF[i].speedL;

	switch (Animation_aF[i].method & 0xC0)
	{
		case VALINEAR:
			if (Animation_aF[i].inc < 0)
			{
				if (Animation_aF[i].to >= (*Animation_aF[i].target + Animation_aF[i].inc))
				{
					*Animation_aF[i].target = Animation_aF[i].to;
					AnimationFState[i] = 0;
					if (Animation_aF[i].callback != NULL_PTR) Animation_aF[i].callback();
				}
				else *Animation_aF[i].target += Animation_aF[i].inc;
			}
			else 
			{
				if (Animation_aF[i].to <= (*Animation_aF[i].target + Animation_aF[i].inc))
				{
					*Animation_aF[i].target = Animation_aF[i].to;
					AnimationFState[i] = 0;
					if (Animation_aF[i].callback != NULL_PTR) Animation_aF[i].callback(); 
				}
				else *Animation_aF[i].target += Animation_aF[i].inc;
				
			}
		break;
		case VADYNAMIC:
		break;
	}
}


